/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class DateHelper {
    private static final String UTC_ISO_DateMask = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final Long NO_DATE = new Long("-2000000000000");
    private static final Date PE_BLANK_DATE_VALUE = new Date(-2000000000000L);
    private static SimpleTimeZone pdt = new SimpleTimeZone(0, "UTC");
    private static final ThreadLocal<SimpleDateFormat> tlDateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public synchronized SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat(DateHelper.UTC_ISO_DateMask);
            sdf.setTimeZone(pdt);
            return sdf;
        }
    };

    private static void writeMsg(String s) {
        System.out.println(Thread.currentThread().getName() + ": " + s);
    }

    public static String convertDateToUTCString(Date theDate) {
        if (theDate == null || theDate.getTime() == NO_DATE.longValue()) {
            return "";
        }
        return tlDateFormatter.get().format(theDate);
    }

    public static Date convertUTCStringToDate(String theDateStr) throws ParseException {
        if (theDateStr == null || theDateStr.length() == 0) {
            return PE_BLANK_DATE_VALUE;
        }
        return tlDateFormatter.get().parse(theDateStr);
    }

    private static String formulateTimeToTwoDigits(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    private static void validateValue(Calendar cal, int type, int value, String desc) {
        assert (cal.get(type) == value) : "Incorrect " + desc + "! should be " + value + " instead it is " + cal.get(type);
    }

    private static String check(int year, int month, int dayOfMonth, int hours, int minutes, int seconds) throws ParseException {
        String s = year + "-" + DateHelper.formulateTimeToTwoDigits(month) + "-" + DateHelper.formulateTimeToTwoDigits(dayOfMonth) + "T" + DateHelper.formulateTimeToTwoDigits(hours) + ":" + DateHelper.formulateTimeToTwoDigits(minutes) + ":" + DateHelper.formulateTimeToTwoDigits(seconds) + "Z";
        Date myDate = DateHelper.convertUTCStringToDate(s);
        Calendar cal = GregorianCalendar.getInstance(pdt);
        cal.setTime(myDate);
        DateHelper.validateValue(cal, 1, year, "year");
        DateHelper.validateValue(cal, 2, month, "month");
        DateHelper.validateValue(cal, 5, dayOfMonth, "day of the month");
        DateHelper.validateValue(cal, 11, year, "hour");
        DateHelper.validateValue(cal, 12, year, "minute");
        DateHelper.validateValue(cal, 13, year, "second");
        String s2 = DateHelper.convertDateToUTCString(myDate);
        assert (s2.equals(s)) : "Date is not matching? " + s + "!=" + s2;
        DateHelper.writeMsg("It's good to go for " + s + ", " + s2 + ", got " + cal.toString());
        return s2;
    }

    public static void main(String[] args) {
        int i = 1;
        try {
            Date dt2 = DateHelper.convertUTCStringToDate("");
            assert (dt2.equals(PE_BLANK_DATE_VALUE)) : "Invalid converstion for empty date string!";
            System.out.println(dt2);
            ArrayList<Thread> testSuite = new ArrayList<Thread>(10);
            Date d = new Date();
            long dValue = d.getTime();
            long aDayInMs = 86400000L;
            int j = 1;
            while (i++ < 20) {
                testSuite.add(new Thread(new TT(new Date(dValue += aDayInMs), i, "Checking " + j++ + " days from today: ")));
            }
            testSuite.add(new Thread(new TT(new Date(-2000000000000L), i++, "Checking 'null' date! ")));
            testSuite.add(new Thread(new TT(2010, 8, 15, 22, 55, 9, i++, "checking 8/15/2010, 22:55:9 ")));
            testSuite.add(new Thread(new TT(2009, 9, 12, 10, 5, 4, i++, "checking 9/12/2009, 10:5:4 ")));
            j = 1;
            for (Thread t : testSuite) {
                t.setName("Thread#" + j++);
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class TT
    implements Runnable {
        String msg;
        int instance;
        Date d = null;
        int year;
        int month;
        int dayOfMonth;
        int hours;
        int minutes;
        int seconds;

        protected TT(Date d, int i, String msg) {
            this.msg = msg;
            this.d = d;
            this.instance = i;
        }

        protected TT(int year, int month, int dayOfMonth, int hours, int minutes, int seconds, int i, String msg) {
            this.msg = msg;
            this.year = year;
            this.month = month;
            this.dayOfMonth = dayOfMonth;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        public void run() {
            if (this.d != null) {
                DateHelper.writeMsg(this.msg + "," + DateHelper.convertDateToUTCString(this.d));
            } else {
                try {
                    DateHelper.writeMsg(this.msg + "," + DateHelper.check(this.year, this.month, this.dayOfMonth, this.hours, this.minutes, this.seconds));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

